/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite_items.handlers;

import com.rolfmao.upgradedcore.compat.ExternalMods;
import com.rolfmao.upgradednetherite.handlers.ArmorEventHandler;
import com.rolfmao.upgradednetherite.utils.tool.CorruptUtil;
import com.rolfmao.upgradednetherite_creative.config.UpgradedNetheriteCreativeConfig;
import com.rolfmao.upgradednetherite_creative.utils.CreativeUtil;
import com.rolfmao.upgradednetherite_items.config.UpgradedNetheriteItemsConfig;
import com.rolfmao.upgradednetherite_items.handlers.PacketHandler;
import com.rolfmao.upgradednetherite_items.init.ModItems;
import com.rolfmao.upgradednetherite_items.init.UpgradedNetheriteEffects;
import com.rolfmao.upgradednetherite_items.items.NetheriteTotem;
import com.rolfmao.upgradednetherite_items.packets.NetheriteTotemEffectPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="upgradednetherite_items", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TotemEventHandler {
    @SubscribeEvent(receiveCanceled=true)
    public void onLivingAttackEvent(LivingHurtEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            List<ItemStack> listTotem = TotemEventHandler.checkNetheriteTotem((PlayerEntity)player);
            if (event.getSource().func_76346_g() != null && !listTotem.isEmpty()) {
                Entity attacker = event.getSource().func_76346_g();
                float bonusreduce = 0.0f;
                if (UpgradedNetheriteItemsConfig.EnableReduceDamageGoldTotem && (TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.GOLD_UPGRADED_NETHERITE_TOTEM.get()) || TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get())) && (attacker instanceof PiglinEntity || attacker instanceof PiglinBruteEntity)) {
                    bonusreduce += (float)UpgradedNetheriteItemsConfig.ReduceDamageGoldTotem;
                }
                if (UpgradedNetheriteItemsConfig.EnableReduceDamageFireTotem && (TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.FIRE_UPGRADED_NETHERITE_TOTEM.get()) || TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get())) && (attacker instanceof BlazeEntity || attacker instanceof MagmaCubeEntity)) {
                    bonusreduce += (float)UpgradedNetheriteItemsConfig.ReduceDamageFireTotem;
                }
                if (UpgradedNetheriteItemsConfig.EnableReduceDamageEnderTotem && (TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ENDER_UPGRADED_NETHERITE_TOTEM.get()) || TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get())) && (attacker instanceof EndermanEntity || attacker instanceof EndermiteEntity || attacker instanceof ShulkerEntity)) {
                    bonusreduce += (float)UpgradedNetheriteItemsConfig.ReduceDamageEnderTotem;
                }
                if (UpgradedNetheriteItemsConfig.EnableReduceDamageWaterTotem && (TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.WATER_UPGRADED_NETHERITE_TOTEM.get()) || TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get())) && (attacker instanceof MonsterEntity && ((MonsterEntity)attacker).func_70668_bt() == CreatureAttribute.field_203100_e || attacker instanceof DrownedEntity)) {
                    bonusreduce += (float)UpgradedNetheriteItemsConfig.ReduceDamageWaterTotem;
                }
                if (UpgradedNetheriteItemsConfig.EnableReduceDamageWitherTotem && (TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.WITHER_UPGRADED_NETHERITE_TOTEM.get()) || TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get())) && attacker instanceof WitherSkeletonEntity) {
                    bonusreduce += (float)UpgradedNetheriteItemsConfig.ReduceDamageWitherTotem;
                }
                if (UpgradedNetheriteItemsConfig.EnableReduceDamagePoisonTotem && (TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.POISON_UPGRADED_NETHERITE_TOTEM.get()) || TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get())) && attacker instanceof MonsterEntity && ((MonsterEntity)attacker).func_70668_bt() == CreatureAttribute.field_223224_c_) {
                    bonusreduce += (float)UpgradedNetheriteItemsConfig.ReduceDamagePoisonTotem;
                }
                if (UpgradedNetheriteItemsConfig.EnableReduceDamagePhantomTotem && (TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.PHANTOM_UPGRADED_NETHERITE_TOTEM.get()) || TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get())) && attacker instanceof PhantomEntity) {
                    bonusreduce += (float)UpgradedNetheriteItemsConfig.ReduceDamagePhantomTotem;
                }
                if (UpgradedNetheriteItemsConfig.EnableReduceDamageFeatherTotem && (TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.FEATHER_UPGRADED_NETHERITE_TOTEM.get()) || TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get())) && attacker instanceof MonsterEntity && ((MonsterEntity)attacker).func_70631_g_()) {
                    bonusreduce += (float)UpgradedNetheriteItemsConfig.ReduceDamageFeatherTotem;
                }
                if (UpgradedNetheriteItemsConfig.EnableReduceDamageCorruptTotem && (TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.CORRUPT_UPGRADED_NETHERITE_TOTEM.get()) || TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get())) && CorruptUtil.intWearingCorruptArmor((PlayerEntity)player, (Boolean)true) > 0) {
                    bonusreduce += (float)(UpgradedNetheriteItemsConfig.ReduceDamageCorruptTotem * CorruptUtil.intWearingCorruptArmor((PlayerEntity)player, (Boolean)true));
                }
                event.setAmount(event.getAmount() - event.getAmount() * Math.min(1.0f, bonusreduce / 100.0f));
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            DamageSource damageSource = event.getSource();
            if (TotemEventHandler.checkNetheriteTotemDeathProtection(damageSource, player)) {
                event.setCanceled(true);
                player.func_184185_a(SoundEvents.field_187798_ea, 1.0f, (new Random().nextFloat() - new Random().nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    public static boolean checkNetheriteTotemDeathProtection(DamageSource damageSource, ServerPlayerEntity player) {
        if (damageSource.func_76357_e() && ExternalMods.UPGRADEDNETHERITE.isLoaded() && damageSource != DamageSource.field_76380_i) {
            return false;
        }
        ItemStack itemstack = null;
        ItemStack itemstackcopy = null;
        for (Hand hand : Hand.values()) {
            ItemStack itemstack1 = player.func_184586_b(hand);
            if (!(itemstack1.func_77973_b() instanceof NetheriteTotem) || !((NetheriteTotem)itemstack1.func_77973_b()).isEnabled() || damageSource == DamageSource.field_76380_i && (!ExternalMods.UPGRADEDNETHERITE_ULTIMATE.isLoaded() || !ItemStack.func_185132_d((ItemStack)itemstack1, (ItemStack)new ItemStack((IItemProvider)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get()))) && (!ExternalMods.UPGRADEDNETHERITE.isLoaded() || !ItemStack.func_185132_d((ItemStack)itemstack1, (ItemStack)new ItemStack((IItemProvider)ModItems.ENDER_UPGRADED_NETHERITE_TOTEM.get())))) continue;
            itemstack = itemstack1;
            itemstackcopy = itemstack1.func_77946_l();
            break;
        }
        if (itemstack == null && ExternalMods.CURIOS.isLoaded()) {
            ItemStack curiostotem = ItemStack.field_190927_a;
            if (damageSource != DamageSource.field_76380_i) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (damageSource != DamageSource.field_76380_i && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.GOLD_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (damageSource != DamageSource.field_76380_i && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.FIRE_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.ENDER_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (damageSource != DamageSource.field_76380_i && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WATER_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (damageSource != DamageSource.field_76380_i && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WITHER_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (damageSource != DamageSource.field_76380_i && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.POISON_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (damageSource != DamageSource.field_76380_i && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.PHANTOM_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (damageSource != DamageSource.field_76380_i && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.FEATHER_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (damageSource != DamageSource.field_76380_i && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CORRUPT_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (ExternalMods.UPGRADEDNETHERITE_ULTIMATE.isLoaded() && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (ExternalMods.UPGRADEDNETHERITE_CREATIVE.isLoaded() && damageSource != DamageSource.field_76380_i && curiostotem.func_190926_b()) {
                curiostotem = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CREATIVE_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            }
            if (!curiostotem.func_190926_b()) {
                itemstack = curiostotem;
                itemstackcopy = curiostotem.func_77946_l();
            }
        }
        if (itemstack != null) {
            if (damageSource == DamageSource.field_76380_i && !ArmorEventHandler.enderSaveVoid((PlayerEntity)player)) {
                return false;
            }
            itemstack.func_190918_g(1);
            player.func_71064_a(Stats.field_75929_E.func_199076_b((Object)Items.field_190929_cY), 1);
            player.func_70606_j(1.0f);
            player.func_195061_cb();
            player.func_195064_c(new EffectInstance(Effects.field_76428_l, 900, 1));
            player.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, 1));
            player.func_195064_c(new EffectInstance(Effects.field_76426_n, 800, 0));
            player.func_195064_c(new EffectInstance((Effect)UpgradedNetheriteEffects.NETHERITE_RESISTANCE.get(), 400, 1));
            player.func_195064_c(new EffectInstance((Effect)UpgradedNetheriteEffects.NETHERITE_STRENGTH.get(), 400, 0));
            PacketHandler.sendToPlayer(new NetheriteTotemEffectPacket(itemstackcopy, (Entity)player), player);
            PacketHandler.sendToAllTracking(new NetheriteTotemEffectPacket(itemstackcopy, (Entity)player), player);
        }
        return itemstack != null;
    }

    private static List<ItemStack> checkNetheriteTotem(PlayerEntity player) {
        ArrayList<ItemStack> listItem = new ArrayList<ItemStack>();
        for (Hand hand : Hand.values()) {
            ItemStack itemstack1 = player.func_184586_b(hand);
            if (!(itemstack1.func_77973_b() instanceof NetheriteTotem)) continue;
            listItem.add(itemstack1);
        }
        if (ExternalMods.CURIOS.isLoaded()) {
            ItemStack itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
            if (!itemstack.func_190926_b()) {
                listItem.add(itemstack);
            }
            if (!(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.GOLD_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (!(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.FIRE_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (!(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.ENDER_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (!(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WATER_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (!(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WITHER_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (!(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.POISON_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (!(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.PHANTOM_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (!(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.FEATHER_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (!(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CORRUPT_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (ExternalMods.UPGRADEDNETHERITE_ULTIMATE.isLoaded() && !(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.ULTIMATE_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
            if (ExternalMods.UPGRADEDNETHERITE_CREATIVE.isLoaded() && !(itemstack = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CREATIVE_UPGRADED_NETHERITE_TOTEM.get(), (LivingEntity)player).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b()) {
                listItem.add(itemstack);
            }
        }
        return listItem;
    }

    private static boolean containNetheriteTotem(List<ItemStack> list, Item item) {
        for (ItemStack stack : list) {
            if (!ItemStack.func_185132_d((ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)item))) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity player;
        List<ItemStack> listTotem;
        if (event.getEntity() instanceof PlayerEntity && !(listTotem = TotemEventHandler.checkNetheriteTotem(player = (PlayerEntity)event.getEntity())).isEmpty() && ExternalMods.UPGRADEDNETHERITE_CREATIVE.isLoaded() && TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.CREATIVE_UPGRADED_NETHERITE_TOTEM.get())) {
            if (UpgradedNetheriteCreativeConfig.EnableCreativeNoHarmful) {
                CreativeUtil.cleanHarmfulEffects((PlayerEntity)player);
            }
            if (UpgradedNetheriteCreativeConfig.EnableCreativeSaturation) {
                if (player.func_71024_bL().func_75116_a() < 20) {
                    player.func_71024_bL().func_75114_a(player.func_71024_bL().func_75116_a() + 1);
                } else if (player.field_70170_p.field_72995_K && player.func_71024_bL().func_75115_e() < 20.0f) {
                    player.func_71024_bL().func_75119_b(player.func_71024_bL().func_75115_e() + 1.0f);
                }
            }
            if (UpgradedNetheriteCreativeConfig.EnableCreativeHeal && player.func_110143_aJ() < player.func_110138_aP()) {
                player.func_70691_i(1.0f);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onApplyEffect(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            List<ItemStack> listTotem = TotemEventHandler.checkNetheriteTotem((PlayerEntity)player);
            if (ExternalMods.UPGRADEDNETHERITE_CREATIVE.isLoaded() && TotemEventHandler.containNetheriteTotem(listTotem, (Item)ModItems.CREATIVE_UPGRADED_NETHERITE_TOTEM.get()) && event.getPotionEffect().func_188419_a().func_220303_e() == EffectType.HARMFUL && UpgradedNetheriteCreativeConfig.EnableCreativeNoHarmful) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

