/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature;

import com.minecraftabnormals.abnormals_core.core.util.BlockUtil;
import com.minecraftabnormals.abnormals_core.core.util.GenerationPiece;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;

public class DriftwoodFeature
extends Feature<NoFeatureConfig> {
    protected static final BlockState DRIFTWOOD_LOG = ((Block)UABlocks.DRIFTWOOD_LOG.get()).func_176223_P();

    public DriftwoodFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        boolean standing = rand.nextFloat() < 0.25f;
        Block downBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (standing && world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && (downBlock.func_203417_a((ITag)Tags.Blocks.DIRT) || downBlock.func_203417_a((ITag)Tags.Blocks.SAND))) {
            Direction upDirection = Direction.UP;
            if (this.isDirectionOpen((IWorld)world, pos, upDirection, 3)) {
                for (int i = 0; i < 3; ++i) {
                    this.placeDriftwoodLog((IWorld)world, pos.func_177967_a(upDirection, i), upDirection, null);
                    if (!rand.nextBoolean()) continue;
                    Direction horizontalDirection = Direction.func_176731_b((int)rand.nextInt(4));
                    if (!world.func_175623_d(pos.func_177967_a(upDirection, i).func_177972_a(horizontalDirection)) || !BlockUtil.isPosNotTouchingBlock((IWorld)world, (BlockPos)pos.func_177967_a(upDirection, i).func_177972_a(horizontalDirection), (Block)((Block)UABlocks.DRIFTWOOD_LOG.get()), (Direction[])new Direction[]{horizontalDirection.func_176734_d()})) continue;
                    this.placeDriftwoodLog((IWorld)world, pos.func_177967_a(upDirection, i).func_177972_a(horizontalDirection), horizontalDirection, null);
                }
                return true;
            }
            return false;
        }
        Direction direction = Direction.func_176731_b((int)rand.nextInt(4));
        int length = rand.nextInt(3) + 3;
        if (rand.nextFloat() < 0.25f && world.func_226691_t_(pos).func_201856_r() == Biome.Category.OCEAN && this.canFitInOcean((IWorld)world, pos, direction, length) && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j && world.func_175623_d(pos.func_177984_a()) || world.func_226691_t_(pos).func_201856_r() != Biome.Category.OCEAN && this.isNearWater((IWorld)world, pos) && downBlock.func_203417_a((ITag)Tags.Blocks.DIRT) || downBlock.func_203417_a((ITag)Tags.Blocks.SAND) && this.isDirectionOpen((IWorld)world, pos, direction, length) && this.isGroundForDirectionMostlySuitable((IWorld)world, pos, direction, length)) {
            GenerationPiece driftwood = new GenerationPiece((iworld, part) -> world.func_175623_d(part.pos) || world.func_204610_c(part.pos).func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a));
            for (int i = 0; i < length; ++i) {
                this.placeDriftwoodLog((IWorld)world, pos.func_177967_a(direction, i), direction, driftwood);
                if (rand.nextBoolean()) {
                    this.placeBranch((IWorld)world, pos.func_177967_a(direction, i), direction, rand, length >= 5, driftwood);
                }
                if (!rand.nextBoolean()) continue;
                Direction upOrDown = rand.nextBoolean() ? Direction.UP : Direction.DOWN;
                if (!this.isBlockPlaceableAtPos((IWorld)world, pos.func_177967_a(direction, i).func_177972_a(upOrDown), world.func_226691_t_(pos.func_177967_a(direction, i).func_177972_a(upOrDown)).func_201856_r() == Biome.Category.OCEAN) || !BlockUtil.isPosNotTouchingBlock((IWorld)world, (BlockPos)pos.func_177967_a(direction, i).func_177972_a(upOrDown), (Block)((Block)UABlocks.DRIFTWOOD_LOG.get()), (Direction[])new Direction[]{Direction.UP, Direction.DOWN})) continue;
                this.placeDriftwoodLog((IWorld)world, pos.func_177967_a(direction, i).func_177972_a(upOrDown), upOrDown, driftwood);
            }
            driftwood.tryToPlace((IWorld)world);
            return true;
        }
        return false;
    }

    private boolean isDirectionOpen(IWorld world, BlockPos pos, Direction direction, int length) {
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        if (direction == Direction.UP) {
            return world.func_204610_c((BlockPos)mutable).func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a) && world.func_175623_d(mutable.func_177984_a()) && world.func_175623_d(mutable.func_177981_b(2));
        }
        for (int i = 0; i < length; ++i) {
            mutable.func_177967_a(direction, i);
            if (world.func_175623_d((BlockPos)mutable) || world.func_204610_c((BlockPos)mutable).func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a)) continue;
            return false;
        }
        return true;
    }

    private boolean canFitInOcean(IWorld world, BlockPos pos, Direction direction, int length) {
        for (int i = 0; i < length; ++i) {
            if (world.func_180495_p(pos.func_177967_a(direction, i)).func_177230_c() == Blocks.field_150355_j) continue;
            return false;
        }
        return true;
    }

    private boolean isGroundForDirectionMostlySuitable(IWorld world, BlockPos pos, Direction direction, int length) {
        int foundGaps = 0;
        for (int i = 0; i < length; ++i) {
            if (world.func_180495_p(pos.func_177977_b().func_177967_a(direction, i)).func_177230_c().func_203417_a((ITag)Tags.Blocks.DIRT) || world.func_180495_p(pos.func_177977_b().func_177967_a(direction, i)).func_177230_c().func_203417_a((ITag)BlockTags.field_203436_u)) continue;
            if (world.func_226691_t_(pos.func_177977_b().func_177967_a(direction, i)).func_201856_r() != Biome.Category.OCEAN) {
                ++foundGaps;
                continue;
            }
            if (world.func_180495_p(pos.func_177977_b().func_177967_a(direction, i)).func_177230_c() == Blocks.field_150355_j) continue;
            ++foundGaps;
        }
        return (double)foundGaps < Math.ceil(length / 2);
    }

    private boolean isNearWater(IWorld world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        int foundWaterSpots = 0;
        if (biome.func_201856_r() == Biome.Category.RIVER) {
            for (int y = pos.func_177956_o() - 2; y < pos.func_177956_o(); ++y) {
                for (int x = pos.func_177958_n() - 3; x < pos.func_177958_n() + 3; ++x) {
                    for (int z = pos.func_177952_p() - 3; z < pos.func_177952_p() + 3; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        if (!world.func_175710_j(currentPos) || world.func_180495_p(currentPos).func_177230_c() != Blocks.field_150355_j) continue;
                        ++foundWaterSpots;
                    }
                }
            }
        } else {
            for (int y = pos.func_177956_o() - 1; y < pos.func_177956_o(); ++y) {
                for (int x = pos.func_177958_n() - 2; x < pos.func_177958_n() + 2; ++x) {
                    for (int z = pos.func_177952_p() - 2; z < pos.func_177952_p() + 2; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        if (!world.func_175710_j(currentPos) || world.func_180495_p(currentPos).func_177230_c() != Blocks.field_150355_j) continue;
                        ++foundWaterSpots;
                    }
                }
            }
        }
        return foundWaterSpots >= 3;
    }

    private void placeDriftwoodLog(IWorld world, BlockPos pos, Direction direction, @Nullable GenerationPiece driftwood) {
        if (driftwood != null) {
            driftwood.addBlockPiece((BlockState)DRIFTWOOD_LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), pos);
        } else {
            world.func_180501_a(pos, (BlockState)DRIFTWOOD_LOG.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), 2);
        }
    }

    private void placeBranch(IWorld world, BlockPos startPos, Direction direction, Random rand, boolean isLarge, GenerationPiece driftwood) {
        int size = isLarge ? rand.nextInt(2) + 1 : 1;
        Direction branchDirection = rand.nextBoolean() ? direction.func_176746_e() : direction.func_176735_f();
        for (int i = 1; i < size + 1; ++i) {
            Block[] sideBlocks = new Block[]{world.func_180495_p(startPos.func_177967_a(branchDirection, i).func_177972_a(branchDirection.func_176746_e())).func_177230_c(), world.func_180495_p(startPos.func_177967_a(branchDirection, i).func_177972_a(branchDirection.func_176735_f())).func_177230_c()};
            if (!this.isBlockPlaceableAtPos(world, startPos.func_177967_a(branchDirection, i), world.func_226691_t_(startPos.func_177967_a(branchDirection, i)).func_201856_r() == Biome.Category.OCEAN) || sideBlocks[0] == DRIFTWOOD_LOG.func_177230_c() || sideBlocks[1] == DRIFTWOOD_LOG.func_177230_c()) break;
            this.placeDriftwoodLog(world, startPos.func_177967_a(branchDirection, i), branchDirection, driftwood);
        }
    }

    private boolean isBlockPlaceableAtPos(IWorld world, BlockPos pos, boolean inOcean) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return inOcean ? world.func_175623_d(pos) || block == Blocks.field_150355_j : world.func_175623_d(pos);
    }
}

