/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.template.Template;
import twilightforest.block.TFBlocks;
import twilightforest.util.FeatureUtil;
import twilightforest.world.feature.config.TFTreeFeatureConfig;

public abstract class TFTreeGenerator<T extends TFTreeFeatureConfig>
extends Feature<T> {
    public TFTreeGenerator(Codec<T> configIn) {
        super(configIn);
    }

    protected boolean generate(IWorld world, Random random, BlockPos pos, Set<BlockPos> logpos, Set<BlockPos> leavespos, MutableBoundingBox mbb, T config) {
        HashSet branchSet = Sets.newHashSet();
        HashSet rootSet = Sets.newHashSet();
        return this.generate(world, random, pos, logpos, leavespos, branchSet, rootSet, mbb, config);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, T config) {
        HashSet logs = Sets.newHashSet();
        HashSet leaves = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.generate((IWorld)world, random, pos, logs, leaves, mutableboundingbox, config);
        if (mutableboundingbox.field_78897_a <= mutableboundingbox.field_78893_d && flag && !logs.isEmpty()) {
            VoxelShapePart voxelshapepart = this.getVoxelShapePart((IWorld)world, mutableboundingbox, logs);
            Template.func_222857_a((IWorld)world, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
            return true;
        }
        return false;
    }

    private VoxelShapePart getVoxelShapePart(IWorld world, MutableBoundingBox mbb, Set<BlockPos> logPosSet) {
        ArrayList list = Lists.newArrayList();
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(mbb.func_78883_b(), mbb.func_78882_c(), mbb.func_78880_d());
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos logPos : Lists.newArrayList(logPosSet)) {
            if (mbb.func_175898_b((Vector3i)logPos)) {
                voxelshapepart.func_199625_a(logPos.func_177958_n() - mbb.field_78897_a, logPos.func_177956_o() - mbb.field_78895_b, logPos.func_177952_p() - mbb.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                mutable.func_239622_a_((Vector3i)logPos, direction);
                if (logPosSet.contains(mutable) || !(blockstate = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)list.get(0)).add(mutable.func_185334_h());
                TreeFeature.func_236408_b_((IWorldWriter)world, (BlockPos)mutable, (BlockState)((BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1))));
                if (!mbb.func_175898_b((Vector3i)mutable)) continue;
                voxelshapepart.func_199625_a(mutable.func_177958_n() - mbb.field_78897_a, mutable.func_177956_o() - mbb.field_78895_b, mutable.func_177952_p() - mbb.field_78896_c, true, true);
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (mbb.func_175898_b((Vector3i)blockpos2)) {
                    voxelshapepart.func_199625_a(blockpos2.func_177958_n() - mbb.field_78897_a, blockpos2.func_177956_o() - mbb.field_78895_b, blockpos2.func_177952_p() - mbb.field_78896_c, true, true);
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    mutable.func_239622_a_((Vector3i)blockpos2, direction1);
                    if (set.contains(mutable) || set1.contains(mutable) || !(blockstate1 = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                    TreeFeature.func_236408_b_((IWorldWriter)world, (BlockPos)mutable, (BlockState)blockstate2);
                    if (mbb.func_175898_b((Vector3i)mutable)) {
                        voxelshapepart.func_199625_a(mutable.func_177958_n() - mbb.field_78897_a, mutable.func_177956_o() - mbb.field_78895_b, mutable.func_177952_p() - mbb.field_78896_c, true, true);
                    }
                    set1.add(mutable.func_185334_h());
                }
            }
        }
        return voxelshapepart;
    }

    protected abstract boolean generate(IWorld var1, Random var2, BlockPos var3, Set<BlockPos> var4, Set<BlockPos> var5, Set<BlockPos> var6, Set<BlockPos> var7, MutableBoundingBox var8, T var9);

    protected boolean setLogBlockState(IWorld world, Random random, BlockPos pos, Set<BlockPos> logPos, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            this.setBlockState((IWorldWriter)world, pos, config.trunkProvider.func_225574_a_(random, pos), mbb);
            logPos.add(pos.func_185334_h());
            return true;
        }
        return false;
    }

    protected boolean setLeavesBlockState(IWorld world, Random random, BlockPos pos, Set<BlockPos> leavesPos, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            this.setBlockState((IWorldWriter)world, pos, config.leavesProvider.func_225574_a_(random, pos), mbb);
            leavesPos.add(pos.func_185334_h());
            return true;
        }
        return false;
    }

    public boolean setBranchBlockState(IWorld world, Random random, BlockPos pos, Set<BlockPos> branchpos, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            this.setBlockState((IWorldWriter)world, pos, config.branchProvider.func_225574_a_(random, pos), mbb);
            branchpos.add(pos.func_185334_h());
            return true;
        }
        return false;
    }

    protected boolean setRootsBlockState(IWorld world, Random random, BlockPos pos, Set<BlockPos> branchpos, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        if (TFTreeGenerator.canRootGrowIn((IWorldReader)world, pos)) {
            this.setBlockState((IWorldWriter)world, pos, config.rootsProvider.func_225574_a_(random, pos), mbb);
            branchpos.add(pos.func_185334_h());
            return true;
        }
        return false;
    }

    protected final void setBlockState(IWorldWriter world, BlockPos pos, BlockState state, MutableBoundingBox mbb) {
        world.func_180501_a(pos, state, 19);
        mbb.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos));
    }

    protected void buildRoot(IWorld world, Random rand, BlockPos pos, Set<BlockPos> setpos, double offset, int b, MutableBoundingBox mbb, T config) {
        BlockPos[] lineArray;
        BlockPos dest = FeatureUtil.translate(pos.func_177979_c(b + 2), 5.0, 0.3 * (double)b + offset, 0.8);
        for (BlockPos coord : lineArray = FeatureUtil.getBresenhamArrays(pos.func_177977_b(), dest)) {
            this.setRootsBlockState(world, rand, coord, setpos, mbb, (TFTreeFeatureConfig)config);
        }
    }

    public static boolean canRootGrowIn(IWorldReader world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        Block blockID = blockState.func_177230_c();
        if (blockState.isAir((IBlockReader)world, pos)) {
            return FeatureUtil.isNearSolid(world, pos);
        }
        return blockState.func_185887_b((IBlockReader)world, pos) >= 0.0f && blockID != TFBlocks.stronghold_shield.get() && blockID != TFBlocks.trophy_pedestal.get() && blockID != TFBlocks.boss_spawner_naga.get() && blockID != TFBlocks.boss_spawner_lich.get() && blockID != TFBlocks.boss_spawner_hydra.get() && blockID != TFBlocks.boss_spawner_ur_ghast.get() && blockID != TFBlocks.boss_spawner_knight_phantom.get() && blockID != TFBlocks.boss_spawner_snow_queen.get() && blockID != TFBlocks.boss_spawner_minoshroom.get() && blockID != TFBlocks.boss_spawner_alpha_yeti.get() && (blockState.func_185904_a() == Material.field_151577_b || blockState.func_185904_a() == Material.field_151578_c || blockState.func_185904_a() == Material.field_151576_e || blockState.func_185904_a() == Material.field_151586_h);
    }

    protected void addFirefly(IWorld world, BlockPos pos, int height, double angle) {
        int iAngle = (int)(angle * 4.0);
        if (iAngle == 0) {
            this.setIfEmpty(world, pos.func_177982_a(1, height, 0), (BlockState)((Block)TFBlocks.firefly.get()).func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.EAST));
        } else if (iAngle == 1) {
            this.setIfEmpty(world, pos.func_177982_a(-1, height, 0), (BlockState)((Block)TFBlocks.firefly.get()).func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.WEST));
        } else if (iAngle == 2) {
            this.setIfEmpty(world, pos.func_177982_a(0, height, 1), (BlockState)((Block)TFBlocks.firefly.get()).func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.SOUTH));
        } else if (iAngle == 3) {
            this.setIfEmpty(world, pos.func_177982_a(0, height, -1), (BlockState)((Block)TFBlocks.firefly.get()).func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.NORTH));
        }
    }

    private void setIfEmpty(IWorld world, BlockPos pos, BlockState state) {
        if (world.func_175623_d(pos)) {
            world.func_180501_a(pos, state, 3);
        }
    }
}

