/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import twilightforest.world.feature.TFTreeGenerator;
import twilightforest.world.feature.config.TFTreeFeatureConfig;

public class FeatureUtil {
    private static final Direction[] directionsExceptDown = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static void putLeafBlock(IWorldGenerationReader world, Random random, BlockPos pos, BlockStateProvider state, Set<BlockPos> leavesPos) {
        if (!TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            return;
        }
        world.func_180501_a(pos, state.func_225574_a_(random, pos), 3);
        leavesPos.add(pos.func_185334_h());
    }

    public static void makeLeafCircle(IWorldGenerationReader world, Random random, BlockPos centerPos, float radius, BlockStateProvider state, Set<BlockPos> leaves) {
        float radiusSquared = radius * radius;
        FeatureUtil.putLeafBlock(world, random, centerPos, state, leaves);
        int x = 0;
        while ((float)x <= radius) {
            int z = 1;
            while ((float)z <= radius) {
                if ((float)(x * x + z * z) <= radiusSquared) {
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(x, 0, z), state, leaves);
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-x, 0, -z), state, leaves);
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-z, 0, x), state, leaves);
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(z, 0, -x), state, leaves);
                }
                ++z;
            }
            ++x;
        }
    }

    public static void makeLeafSpheroid(IWorldGenerationReader world, Random random, BlockPos centerPos, float xzRadius, float yRadius, float verticalBias, BlockStateProvider state, Set<BlockPos> leaves) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeatureUtil.putLeafBlock(world, random, centerPos, state, leaves);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(x, 0, z), state, leaves);
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-x, 0, -z), state, leaves);
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-z, 0, x), state, leaves);
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(z, 0, -x), state, leaves);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + ((float)y2 - verticalBias) * ((float)y2 - verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(x, y2, z), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-x, y2, -z), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-z, y2, x), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(z, y2, -x), state, leaves);
                        }
                        if (xzSquare + ((float)y2 + verticalBias) * ((float)y2 + verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(x, -y2, z), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-x, -y2, -z), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-z, -y2, x), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(z, -y2, -x), state, leaves);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static void makeLeafSpheroid(IWorldGenerationReader world, Random random, BlockPos centerPos, float radius, BlockStateProvider state, Set<BlockPos> leaves) {
        float radiusSquared = radius * radius;
        FeatureUtil.putLeafBlock(world, random, centerPos, state, leaves);
        int y = 0;
        while ((float)y <= radius) {
            if (!((float)y > radius)) {
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
                FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(0, -y, 0), state, leaves);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= radius) {
            int z = 1;
            while ((float)z <= radius) {
                float xzSquare = x * x + z * z;
                if (!(xzSquare > radiusSquared)) {
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(x, 0, z), state, leaves);
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-x, 0, -z), state, leaves);
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-z, 0, x), state, leaves);
                    FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(z, 0, -x), state, leaves);
                    int y2 = 1;
                    while ((float)y2 <= radius) {
                        if (xzSquare + (float)(y2 * y2) <= radius * radius) {
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(x, y2, z), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-x, y2, -z), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-z, y2, x), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(z, y2, -x), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(x, -y2, z), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-x, -y2, -z), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(-z, -y2, x), state, leaves);
                            FeatureUtil.putLeafBlock(world, random, centerPos.func_177982_a(z, -y2, -x), state, leaves);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static boolean hasAirAround(IWorldGenerationReader world, BlockPos pos) {
        for (Direction e : directionsExceptDown) {
            if (!world.func_217375_a(pos, b -> b.func_177230_c() instanceof AirBlock)) continue;
            return true;
        }
        return false;
    }

    public static void drawBresenhamBranch(IWorldGenerationReader world, Random random, BlockPos from, BlockPos to, Set<BlockPos> state, MutableBoundingBox mbb, BaseTreeFeatureConfig config) {
        for (BlockPos pixel : FeatureUtil.getBresenhamArrays(from, to)) {
            AbstractTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)pixel, state, (MutableBoundingBox)mbb, (BaseTreeFeatureConfig)config);
        }
    }

    public static BlockPos translate(BlockPos pos, double distance, double angle, double tilt) {
        double rangle = angle * 2.0 * Math.PI;
        double rtilt = tilt * Math.PI;
        return pos.func_177963_a((double)Math.round(Math.sin(rangle) * Math.sin(rtilt) * distance), (double)Math.round(Math.cos(rtilt) * distance), (double)Math.round(Math.cos(rangle) * Math.sin(rtilt) * distance));
    }

    public static void drawBresenhamBranch(TFTreeGenerator<? extends TFTreeFeatureConfig> generator, IWorld world, Random random, BlockPos from, BlockPos to, Set<BlockPos> state, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        for (BlockPos pixel : FeatureUtil.getBresenhamArrays(from, to)) {
            generator.setBranchBlockState(world, random, pixel, state, mbb, config);
        }
    }

    public static void drawBresenhamTree(IWorld world, BlockPos from, BlockPos to, BlockState state, Set<BlockPos> treepos) {
        for (BlockPos pixel : FeatureUtil.getBresenhamArrays(from, to)) {
            world.func_180501_a(pixel, state, 3);
            treepos.add(pixel.func_185334_h());
        }
    }

    public static BlockPos[] getBresenhamArrays(BlockPos src, BlockPos dest) {
        return FeatureUtil.getBresenhamArrays(src.func_177958_n(), src.func_177956_o(), src.func_177952_p(), dest.func_177958_n(), dest.func_177956_o(), dest.func_177952_p());
    }

    public static BlockPos[] getBresenhamArrays(int x1, int y1, int z1, int x2, int y2, int z2) {
        BlockPos[] lineArray;
        BlockPos pixel = new BlockPos(x1, y1, z1);
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int absDx = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int absDy = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int absDz = Math.abs(dz);
        int doubleAbsDx = absDx << 1;
        int doubleAbsDy = absDy << 1;
        int doubleAbsDz = absDz << 1;
        if (absDx >= absDy && absDx >= absDz) {
            int err_1 = doubleAbsDy - absDx;
            int err_2 = doubleAbsDz - absDx;
            lineArray = new BlockPos[absDx + 1];
            for (int i = 0; i < absDx; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177981_b(y_inc);
                    err_1 -= doubleAbsDx;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177970_e(z_inc);
                    err_2 -= doubleAbsDx;
                }
                err_1 += doubleAbsDy;
                err_2 += doubleAbsDz;
                pixel = pixel.func_177965_g(x_inc);
            }
        } else if (absDy >= absDx && absDy >= absDz) {
            int err_1 = doubleAbsDx - absDy;
            int err_2 = doubleAbsDz - absDy;
            lineArray = new BlockPos[absDy + 1];
            for (int i = 0; i < absDy; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177965_g(x_inc);
                    err_1 -= doubleAbsDy;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177970_e(z_inc);
                    err_2 -= doubleAbsDy;
                }
                err_1 += doubleAbsDx;
                err_2 += doubleAbsDz;
                pixel = pixel.func_177981_b(y_inc);
            }
        } else {
            int err_1 = doubleAbsDy - absDz;
            int err_2 = doubleAbsDx - absDz;
            lineArray = new BlockPos[absDz + 1];
            for (int i = 0; i < absDz; ++i) {
                lineArray[i] = pixel;
                if (err_1 > 0) {
                    pixel = pixel.func_177981_b(y_inc);
                    err_1 -= doubleAbsDz;
                }
                if (err_2 > 0) {
                    pixel = pixel.func_177965_g(x_inc);
                    err_2 -= doubleAbsDz;
                }
                err_1 += doubleAbsDy;
                err_2 += doubleAbsDx;
                pixel = pixel.func_177970_e(z_inc);
            }
        }
        lineArray[lineArray.length - 1] = pixel;
        return lineArray;
    }

    public static void makeLeafCircle(IWorld world, BlockPos pos, int rad, BlockState state, Set<BlockPos> leaves, boolean useHack) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = Math.max(dx, dz) + (Math.min(dx, dz) >> 1);
                if (useHack && dx == 3 && dz == 3) {
                    dist = 6;
                }
                if (dist > rad) continue;
                FeatureUtil.putLeafBlock(world, pos.func_177982_a(dx, 0, dz), state, leaves);
                FeatureUtil.putLeafBlock(world, pos.func_177982_a(dx, 0, -dz), state, leaves);
                FeatureUtil.putLeafBlock(world, pos.func_177982_a(-dx, 0, dz), state, leaves);
                FeatureUtil.putLeafBlock(world, pos.func_177982_a(-dx, 0, -dz), state, leaves);
            }
        }
    }

    public static void putLeafBlock(IWorld world, BlockPos pos, BlockState state, Set<BlockPos> leavespos) {
        BlockState whatsThere = world.func_180495_p(pos);
        if (whatsThere.canBeReplacedByLeaves((IWorldReader)world, pos) && whatsThere.func_177230_c() != state.func_177230_c()) {
            world.func_180501_a(pos, state, 3);
            leavespos.add(pos.func_185334_h());
        }
    }

    public static void makeLeafCircle2(IWorld world, BlockPos pos, int rad, BlockState state, Set<BlockPos> leaves) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                if (dx * dx + dz * dz > rad * rad) continue;
                FeatureUtil.putLeafBlock(world, pos.func_177982_a(1 + dx, 0, 1 + dz), state, leaves);
                FeatureUtil.putLeafBlock(world, pos.func_177982_a(1 + dx, 0, -dz), state, leaves);
                FeatureUtil.putLeafBlock(world, pos.func_177982_a(-dx, 0, 1 + dz), state, leaves);
                FeatureUtil.putLeafBlock(world, pos.func_177982_a(-dx, 0, -dz), state, leaves);
            }
        }
    }

    public static BlockState randStone(Random rand, int howMuch) {
        return rand.nextInt(howMuch) >= 1 ? Blocks.field_150347_e.func_176223_P() : Blocks.field_150341_Y.func_176223_P();
    }

    public static boolean isAreaSuitable(IWorld world, BlockPos pos, int width, int height, int depth) {
        boolean flag = true;
        for (int cx = 0; cx < width; ++cx) {
            for (int cz = 0; cz < depth; ++cz) {
                BlockPos pos_ = pos.func_177982_a(cx, 0, cz);
                if (world.func_175667_e(pos_)) {
                    Material m = world.func_180495_p(pos_.func_177977_b()).func_185904_a();
                    if (m != Material.field_151578_c && m != Material.field_151577_b && m != Material.field_151576_e) {
                        flag = false;
                    }
                    for (int cy = 0; cy < height; ++cy) {
                        if (world.func_175623_d(pos_.func_177981_b(cy))) continue;
                        flag = false;
                    }
                    continue;
                }
                flag = false;
            }
        }
        return flag;
    }

    public static void drawBlob(IWorld world, BlockPos pos, int rad, BlockState state) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    world.func_180501_a(pos.func_177982_a(dx, dy, dz), state, 3);
                    world.func_180501_a(pos.func_177982_a(dx, dy, -dz), state, 3);
                    world.func_180501_a(pos.func_177982_a(-dx, dy, dz), state, 3);
                    world.func_180501_a(pos.func_177982_a(-dx, dy, -dz), state, 3);
                    world.func_180501_a(pos.func_177982_a(dx, -dy, dz), state, 3);
                    world.func_180501_a(pos.func_177982_a(dx, -dy, -dz), state, 3);
                    world.func_180501_a(pos.func_177982_a(-dx, -dy, dz), state, 3);
                    world.func_180501_a(pos.func_177982_a(-dx, -dy, -dz), state, 3);
                }
            }
        }
    }

    public static void drawLeafBlob(IWorld world, BlockPos pos, int rad, BlockState state, Set<BlockPos> leaves) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    FeatureUtil.putLeafBlock(world, pos.func_177982_a(dx, dy, dz), state, leaves);
                    FeatureUtil.putLeafBlock(world, pos.func_177982_a(dx, dy, -dz), state, leaves);
                    FeatureUtil.putLeafBlock(world, pos.func_177982_a(-dx, dy, dz), state, leaves);
                    FeatureUtil.putLeafBlock(world, pos.func_177982_a(-dx, dy, -dz), state, leaves);
                    FeatureUtil.putLeafBlock(world, pos.func_177982_a(dx, -dy, dz), state, leaves);
                    FeatureUtil.putLeafBlock(world, pos.func_177982_a(dx, -dy, -dz), state, leaves);
                    FeatureUtil.putLeafBlock(world, pos.func_177982_a(-dx, -dy, dz), state, leaves);
                    FeatureUtil.putLeafBlock(world, pos.func_177982_a(-dx, -dy, -dz), state, leaves);
                }
            }
        }
    }

    public static boolean surroundedByAir(IWorldReader world, BlockPos pos) {
        for (Direction e : Direction.values()) {
            if (world.func_175623_d(pos.func_177972_a(e))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAirAround(IWorld world, BlockPos pos) {
        for (Direction e : directionsExceptDown) {
            if (!world.func_175623_d(pos.func_177972_a(e))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNearSolid(IWorldReader world, BlockPos pos) {
        for (Direction e : Direction.values()) {
            if (!world.func_175667_e(pos.func_177972_a(e)) || !world.func_180495_p(pos.func_177972_a(e)).func_185904_a().func_76220_a()) continue;
            return true;
        }
        return false;
    }

    public static void setBlockStateProvider(IWorld world, BlockStateProvider provider, Random rand, BlockPos pos) {
        world.func_180501_a(pos, provider.func_225574_a_(rand, pos), 3);
    }
}

