/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import twilightforest.TwilightForestMod;
import twilightforest.loot.conditions.IsMinion;
import twilightforest.loot.conditions.ModExists;
import twilightforest.loot.functions.Enchant;
import twilightforest.loot.functions.ModItemSwap;

public class TFTreasure {
    private static final Set<ResourceLocation> TF_LOOT_TABLES = Sets.newHashSet();
    public static final TFTreasure hill1 = new TFTreasure("hill_1");
    public static final TFTreasure hill2 = new TFTreasure("hill_2");
    public static final TFTreasure hill3 = new TFTreasure("hill_3");
    public static final TFTreasure hedgemaze = new TFTreasure("hedge_maze");
    public static final TFTreasure labyrinth_room = new TFTreasure("labyrinth_room");
    public static final TFTreasure labyrinth_deadend = new TFTreasure("labyrinth_dead_end");
    public static final TFTreasure tower_room = new TFTreasure("tower_room");
    public static final TFTreasure tower_library = new TFTreasure("tower_library");
    public static final TFTreasure basement = new TFTreasure("basement");
    public static final TFTreasure labyrinth_vault = new TFTreasure("labyrinth_vault");
    public static final TFTreasure darktower_cache = new TFTreasure("darktower_cache");
    public static final TFTreasure darktower_key = new TFTreasure("darktower_key");
    public static final TFTreasure darktower_boss = new TFTreasure("darktower_boss");
    public static final TFTreasure tree_cache = new TFTreasure("tree_cache");
    public static final TFTreasure stronghold_cache = new TFTreasure("stronghold_cache");
    public static final TFTreasure stronghold_room = new TFTreasure("stronghold_room");
    public static final TFTreasure stronghold_boss = new TFTreasure("stronghold_boss");
    public static final TFTreasure aurora_cache = new TFTreasure("aurora_cache");
    public static final TFTreasure aurora_room = new TFTreasure("aurora_room");
    public static final TFTreasure troll_garden = new TFTreasure("troll_garden");
    public static final TFTreasure troll_vault = new TFTreasure("troll_vault");
    public static final TFTreasure graveyard = new TFTreasure("graveyard");
    public static final ResourceLocation BIGHORN_SHEEP_WHITE = TFTreasure.register("entities/bighorn_sheep/white");
    public static final ResourceLocation BIGHORN_SHEEP_ORANGE = TFTreasure.register("entities/bighorn_sheep/orange");
    public static final ResourceLocation BIGHORN_SHEEP_MAGENTA = TFTreasure.register("entities/bighorn_sheep/magenta");
    public static final ResourceLocation BIGHORN_SHEEP_LIGHT_BLUE = TFTreasure.register("entities/bighorn_sheep/light_blue");
    public static final ResourceLocation BIGHORN_SHEEP_YELLOW = TFTreasure.register("entities/bighorn_sheep/yellow");
    public static final ResourceLocation BIGHORN_SHEEP_LIME = TFTreasure.register("entities/bighorn_sheep/lime");
    public static final ResourceLocation BIGHORN_SHEEP_PINK = TFTreasure.register("entities/bighorn_sheep/pink");
    public static final ResourceLocation BIGHORN_SHEEP_GRAY = TFTreasure.register("entities/bighorn_sheep/gray");
    public static final ResourceLocation BIGHORN_SHEEP_LIGHT_GRAY = TFTreasure.register("entities/bighorn_sheep/light_gray");
    public static final ResourceLocation BIGHORN_SHEEP_CYAN = TFTreasure.register("entities/bighorn_sheep/cyan");
    public static final ResourceLocation BIGHORN_SHEEP_PURPLE = TFTreasure.register("entities/bighorn_sheep/purple");
    public static final ResourceLocation BIGHORN_SHEEP_BLUE = TFTreasure.register("entities/bighorn_sheep/blue");
    public static final ResourceLocation BIGHORN_SHEEP_BROWN = TFTreasure.register("entities/bighorn_sheep/brown");
    public static final ResourceLocation BIGHORN_SHEEP_GREEN = TFTreasure.register("entities/bighorn_sheep/green");
    public static final ResourceLocation BIGHORN_SHEEP_RED = TFTreasure.register("entities/bighorn_sheep/red");
    public static final ResourceLocation BIGHORN_SHEEP_BLACK = TFTreasure.register("entities/bighorn_sheep/black");
    public static final ResourceLocation QUESTING_RAM_REWARDS = TFTreasure.register("entities/questing_ram_rewards");
    public static final ResourceLocation DEATH_TOME_HURT = TFTreasure.register("entities/death_tome_hurt");
    public static final ResourceLocation DEATH_TOME_BOOKS = TFTreasure.register("entities/death_tome_books");
    public static final ResourceLocation USELESS_LOOT = TFTreasure.register("structures/useless");
    public static final ResourceLocation ALL_BOSSES = TFTreasure.register("entities/all_bosses");
    public static LootFunctionType ENCHANT;
    public static LootFunctionType ITEM_OR_DEFAULT;
    public static LootConditionType IS_MINION;
    public static LootConditionType MOD_EXISTS;
    public final ResourceLocation lootTable;

    private TFTreasure(String path) {
        this.lootTable = TwilightForestMod.prefix(String.format("structures/%s", path));
    }

    public static void init() {
        ENCHANT = TFTreasure.registerFunction("enchant", new LootFunctionType((ILootSerializer)new Enchant.Serializer()));
        ITEM_OR_DEFAULT = TFTreasure.registerFunction("item_or_default", new LootFunctionType((ILootSerializer)new ModItemSwap.Serializer()));
        IS_MINION = TFTreasure.registerCondition("is_minion", new LootConditionType((ILootSerializer)new IsMinion.Serializer()));
        MOD_EXISTS = TFTreasure.registerCondition("mod_exists", new LootConditionType((ILootSerializer)new ModExists.Serializer()));
    }

    public void generateChest(IWorld world, BlockPos pos, Direction dir, boolean trapped) {
        world.func_180501_a(pos, (BlockState)(trapped ? Blocks.field_150447_bR : Blocks.field_150486_ae).func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)dir), 2);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ChestTileEntity) {
            ((ChestTileEntity)te).func_189404_a(this.lootTable, ((ISeedReader)world).func_72905_C() * (long)pos.func_177958_n() + (long)pos.func_177956_o() ^ (long)pos.func_177952_p());
        }
    }

    public void generateChestContents(ISeedReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ChestTileEntity) {
            ((ChestTileEntity)te).func_189404_a(this.lootTable, world.func_72905_C() * (long)pos.func_177958_n() + (long)pos.func_177956_o() ^ (long)pos.func_177952_p());
        }
    }

    private static LootFunctionType registerFunction(String name, LootFunctionType function) {
        return (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)TwilightForestMod.prefix(name), (Object)function);
    }

    private static LootConditionType registerCondition(String name, LootConditionType condition) {
        return (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)TwilightForestMod.prefix(name), (Object)condition);
    }

    private static ResourceLocation register(String id) {
        return TFTreasure.register(TwilightForestMod.prefix(id));
    }

    private static ResourceLocation register(ResourceLocation id) {
        if (TF_LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(id + " is already a registered built-in loot table");
    }
}

