/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.blocks;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public interface IOwnerProtected {
    @Nullable
    public UUID getOwner();

    public void setOwner(@Nullable UUID var1);

    default public void saveOwner(CompoundNBT tag) {
        UUID owner = this.getOwner();
        if (owner != null) {
            tag.func_186854_a("Owner", owner);
        }
    }

    default public void loadOwner(CompoundNBT tag) {
        if (tag.func_74764_b("Owner")) {
            this.setOwner(tag.func_186857_a("Owner"));
        }
    }

    default public boolean isOwnedBy(PlayerEntity player) {
        UUID id = this.getOwner();
        return id != null && id.equals(player.func_110124_au());
    }

    default public boolean isPublic() {
        return this.getOwner() == null;
    }

    default public boolean isAccessibleBy(PlayerEntity player) {
        return this.isPublic() || this.isOwnedBy(player);
    }

    default public boolean isNotOwnedBy(PlayerEntity player) {
        UUID id = this.getOwner();
        return id != null && !id.equals(player.func_110124_au());
    }
}

