/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.mixin.datafixerupper;

import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SharedConstants;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.WorldSummary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={MinecraftServer.class})
public final class MinecraftServerMixin {
    @Redirect(method={"convertLevel"}, at=@At(value="INVOKE", target="net/minecraft/world/storage/SaveFormat$LevelSave.needsConversion()Z"))
    private static boolean needsConversion(SaveFormat.LevelSave save) {
        WorldSummary worldSummary = save.func_237296_d_();
        if (worldSummary == null) {
            return false;
        }
        int version = worldSummary.func_237314_k_().field_237321_d_;
        if (save.func_237295_c_() || version != SharedConstants.func_215069_a().getWorldVersion()) {
            throw new RuntimeException("Worlds last played on an older or newer version of Minecraft cannot be loaded when DataFixerUpper is disabled by RandomPatches.");
        }
        return false;
    }
}

