/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class Waystone
implements IWaystone,
IMutableWaystone {
    private final ResourceLocation waystoneType;
    private final UUID waystoneUid;
    private final boolean wasGenerated;
    private RegistryKey<World> dimension;
    private BlockPos pos;
    private String name = "";
    private boolean isGlobal;
    private UUID ownerUid;

    public Waystone(ResourceLocation waystoneType, UUID waystoneUid, RegistryKey<World> dimension, BlockPos pos, boolean wasGenerated, @Nullable UUID ownerUid) {
        this.waystoneType = waystoneType;
        this.waystoneUid = waystoneUid;
        this.dimension = dimension;
        this.pos = pos;
        this.wasGenerated = wasGenerated;
        this.ownerUid = ownerUid;
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    @Override
    public boolean wasGenerated() {
        return this.wasGenerated;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    @Override
    public boolean isOwner(PlayerEntity player) {
        return this.ownerUid == null || player.func_146103_bH().getId().equals(this.ownerUid) || player.field_71075_bZ.field_75098_d;
    }

    @Override
    public void setOwnerUid(@Nullable UUID ownerUid) {
        this.ownerUid = ownerUid;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public UUID getOwnerUid() {
        return this.ownerUid;
    }

    @Override
    public void setDimension(RegistryKey<World> dimension) {
        this.dimension = dimension;
    }

    @Override
    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public ResourceLocation getWaystoneType() {
        return this.waystoneType;
    }

    public static IWaystone read(PacketBuffer buf) {
        UUID waystoneUid = buf.func_179253_g();
        ResourceLocation waystoneType = buf.func_192575_l();
        String name = buf.func_218666_n();
        boolean isGlobal = buf.readBoolean();
        RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(250)));
        BlockPos pos = buf.func_179259_c();
        Waystone waystone = new Waystone(waystoneType, waystoneUid, (RegistryKey<World>)dimension, pos, false, null);
        waystone.setName(name);
        waystone.setGlobal(isGlobal);
        return waystone;
    }

    public static IWaystone read(CompoundNBT compound) {
        UUID waystoneUid = NBTUtil.func_186860_b((INBT)Objects.requireNonNull(compound.func_74781_a("WaystoneUid")));
        String name = compound.func_74779_i("Name");
        RegistryKey dimensionType = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("World")));
        BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("BlockPos"));
        boolean wasGenerated = compound.func_74767_n("WasGenerated");
        UUID ownerUid = compound.func_74764_b("OwnerUid") ? NBTUtil.func_186860_b((INBT)Objects.requireNonNull(compound.func_74781_a("OwnerUid"))) : null;
        ResourceLocation waystoneType = compound.func_74764_b("Type") ? new ResourceLocation(compound.func_74779_i("Type")) : WaystoneTypes.WAYSTONE;
        Waystone waystone = new Waystone(waystoneType, waystoneUid, (RegistryKey<World>)dimensionType, pos, wasGenerated, ownerUid);
        waystone.setName(name);
        waystone.setGlobal(compound.func_74767_n("IsGlobal"));
        return waystone;
    }

    public static void write(PacketBuffer buf, IWaystone waystone) {
        buf.func_179252_a(waystone.getWaystoneUid());
        buf.func_192572_a(waystone.getWaystoneType());
        buf.func_180714_a(waystone.getName());
        buf.writeBoolean(waystone.isGlobal());
        buf.func_192572_a(waystone.getDimension().func_240901_a_());
        buf.func_179255_a(waystone.getPos());
    }

    public static CompoundNBT write(IWaystone waystone, CompoundNBT compound) {
        compound.func_218657_a("WaystoneUid", (INBT)NBTUtil.func_240626_a_((UUID)waystone.getWaystoneUid()));
        compound.func_74778_a("Type", waystone.getWaystoneType().toString());
        compound.func_74778_a("Name", waystone.getName());
        compound.func_74778_a("World", waystone.getDimension().func_240901_a_().toString());
        compound.func_218657_a("BlockPos", (INBT)NBTUtil.func_186859_a((BlockPos)waystone.getPos()));
        compound.func_74757_a("WasGenerated", waystone.wasGenerated());
        if (waystone.getOwnerUid() != null) {
            compound.func_218657_a("OwnerUid", (INBT)NBTUtil.func_240626_a_((UUID)waystone.getOwnerUid()));
        }
        compound.func_74757_a("IsGlobal", waystone.isGlobal());
        return compound;
    }
}

